@extends('layouts.app')
@section('content')<section class="login">
    <div class="login-box">
        <div class="login-logo">
            <a href="{{ route('admin.home') }}">
                {{ trans('global.site_title') }}
            </a>
        </div>
        <div class="login-box-body">
            <p class="login-box-msg">
                {{ trans('global.reset_password') }}
            </p>
            @if (session('error'))
                <div class="alert alert-danger">
                    {{ session('error') }}
                </div>
            @endif
            @if(session('status'))
                <div class="alert alert-success" role="alert">
                    {{ session('status') }}
                </div>
            @endif

            <form method="POST" action="{{ route('password.email') }}">
                @csrf

                <div>
                    <div class="form-group{{ $errors->has('email') ? ' has-error' : '' }}">
                        <input id="email" type="email" class="form-control" name="email" required autocomplete="email"
                            autofocus placeholder="{{ trans('global.login_email') }}" value="{{ old('email') }}">
 <span class="glyphicon glyphicon-envelope form-control-feedback"></span>
                        @if($errors->has('email'))
                            <span class="help-block" role="alert">
                                {{ $errors->first('email') }}
                            </span>
                        @endif
                    </div>
                    <div class="row">
                        <div class="col-xs-12">
                            <button type="submit" class="btn btn-primary btn-flat btn-block">
                                {{ trans('global.send_password') }}
                            </button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection